// ===== GESTION DES FONCTIONNALITÉS FINALES =====
// Version améliorée avec code robuste et bonnes couleurs

// ===== 1. SÉLECTEUR D'ANNÉE DU TITRE =====
function initYearSelect() {
    const highlightYear = document.querySelector('.highlight-year');
    const yearFilter = document.getElementById('yearFilter');
    
    if (!highlightYear) {
        console.warn('highlightYear non trouvé');
        return;
    }
    
    if (!yearFilter) {
        console.warn('yearFilter non trouvé');
        return;
    }
    
    // Rendre le titre cliquable
    highlightYear.style.cursor = 'pointer';
    highlightYear.style.userSelect = 'none';
    
    // Créer un menu déroulant au clic
    highlightYear.addEventListener('click', (e) => {
        e.stopPropagation();
        
        // Vérifier si le menu existe déjà
        let existingMenu = document.getElementById('yearDropdownMenu');
        if (existingMenu) {
            existingMenu.remove();
            return;
        }
        
        // Créer le menu déroulant
        const menu = document.createElement('div');
        menu.id = 'yearDropdownMenu';
        menu.style.cssText = `
            position: fixed;
            background: rgba(20, 20, 50, 0.98);
            border: 2px solid rgba(0, 212, 255, 0.4);
            border-radius: 10px;
            padding: 8px;
            z-index: 10000;
            max-height: 300px;
            overflow-y: auto;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(10px);
            min-width: 120px;
        `;
        
        // Ajouter les options d'années
        const years = Array.from(yearFilter.options).map(opt => opt.value);
        
        if (years.length === 0) {
            menu.innerHTML = '<div style="padding: 10px; color: #fff;">Aucune année</div>';
            document.body.appendChild(menu);
            positionMenu();
            return;
        }
        
        years.forEach(year => {
            const option = document.createElement('div');
            option.textContent = year;
            option.style.cssText = `
                padding: 10px 16px;
                color: #f0f0f0;
                cursor: pointer;
                border-radius: 6px;
                transition: all 0.2s ease;
                font-weight: 600;
                text-align: center;
                margin: 2px 0;
            `;
            
            if (year === yearFilter.value) {
                option.style.background = 'linear-gradient(135deg, #00d4ff 0%, #0099cc 100%)';
                option.style.boxShadow = '0 2px 10px rgba(0, 212, 255, 0.3)';
            }
            
            option.addEventListener('mouseenter', function() {
                if (year !== yearFilter.value) {
                    this.style.background = 'rgba(0, 212, 255, 0.2)';
                }
            });
            
            option.addEventListener('mouseleave', function() {
                if (year !== yearFilter.value) {
                    this.style.background = 'transparent';
                }
            });
            
            option.addEventListener('click', () => {
                selectYear(year);
                menu.remove();
            });
            
            menu.appendChild(option);
        });
        
        document.body.appendChild(menu);
        positionMenu();
        
        // Fermer le menu si on clique ailleurs
        setTimeout(() => {
            document.addEventListener('click', function closeMenu(e) {
                if (!menu.contains(e.target) && e.target !== highlightYear) {
                    menu.remove();
                    document.removeEventListener('click', closeMenu);
                }
            });
        }, 100);
        
        function positionMenu() {
            const rect = highlightYear.getBoundingClientRect();
            menu.style.top = (rect.bottom + 8) + 'px';
            menu.style.left = Math.min(rect.left, window.innerWidth - 150) + 'px';
        }
    });
    
    function selectYear(year) {
        yearFilter.value = year;
        highlightYear.innerHTML = `${year} <i class="fas fa-sort-down"></i>`;
        
        // Mettre à jour les graphiques
        if (typeof initMainChart === 'function') {
            initMainChart();
        }
        
        // Mettre à jour le titre du graphique
        if (typeof updateChartTitle === 'function') {
            updateChartTitle();
        }
        
        // Mettre à jour les stats mathématiques
        if (typeof updateMathematicalStats === 'function') {
            updateMathematicalStats(year);
        }
        
        // Animation de mise à jour des valeurs
        document.querySelectorAll('.metric-value').forEach(el => {
            el.classList.add('updating');
            setTimeout(() => el.classList.remove('updating'), 600);
        });
    }
}

// ===== 2. BOUTON RETOUR MODE ARTISTIQUE =====
function initBackButton() {
    const btnBack = document.getElementById('btnBackToHome');
    const labSwitch = document.getElementById('lab-switch');
    
    if (btnBack) {
        btnBack.addEventListener('click', () => {
            if (labSwitch) {
                labSwitch.checked = false;
                labSwitch.dispatchEvent(new Event('change'));
            }
        });
    }
}

// ===== 3. ANIMATION GLITCH ENTRE GRAPHIQUES =====
function addGlitchTransition() {
    const chartArea = document.querySelector('.chart-area');
    if (!chartArea) return;
    
    // Les animations de glitch sont gérées dans CSS
    // Cette fonction peut être étendue pour des effets supplémentaires
}

// ===== 4. FILTRE TV/RADIO =====
let currentMediaFilter = 'all';

function createMediaFilter() {
    const mainContent = document.querySelector('.main-content');
    if (!mainContent) return;
    
    // Vérifier si le filtre existe déjà
    if (document.querySelector('.media-filter')) return;
    
    const filterDiv = document.createElement('div');
    filterDiv.className = 'media-filter';
    filterDiv.innerHTML = `
        <button class="filter-btn all-filter active" data-filter="all">
            <i class="fas fa-globe"></i> Tous
        </button>
        <button class="filter-btn tv-filter" data-filter="tv">
            <i class="fas fa-tv"></i> TV
        </button>
        <button class="filter-btn radio-filter" data-filter="radio">
            <i class="fas fa-broadcast-tower"></i> Radio
        </button>
    `;
    
    mainContent.appendChild(filterDiv);
    
    // Event listeners
    filterDiv.querySelectorAll('.filter-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const filter = this.dataset.filter;
            currentMediaFilter = filter;
            
            // Mettre à jour les boutons actifs
            filterDiv.querySelectorAll('.filter-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            // Recharger le graphique avec le filtre
            if (typeof initMainChart === 'function') {
                initMainChart();
            }
        });
    });
}

// Export du filtre pour l'utiliser dans main-chart.js
window.getCurrentMediaFilter = function() {
    return currentMediaFilter;
};

// ===== 5. SUPERPOSITION IMAGE ILLUSTRATOR MODE ARTISTIQUE =====
function addIllustratorOverlay() {
    const artisticContainer = document.getElementById('artistic-d3-container');
    if (!artisticContainer) return;
    
    // Vérifier si l'overlay existe déjà
    if (document.querySelector('.illustrator-overlay-container')) return;
    
    // Créer le conteneur pour l'overlay
    const overlayDiv = document.createElement('div');
    overlayDiv.className = 'illustrator-overlay-container';
    overlayDiv.innerHTML = `
        <img src="" alt="Overlay Illustrator" class="illustrator-overlay-image" id="illustratorOverlay">
    `;
    artisticContainer.appendChild(overlayDiv);
    
    // Créer le bouton de toggle
    const toggleBtn = document.createElement('button');
    toggleBtn.className = 'btn-toggle-illustrator';
    toggleBtn.innerHTML = '<i class="fas fa-image"></i> Superposer';
    toggleBtn.id = 'btnToggleIllustrator';
    artisticContainer.appendChild(toggleBtn);
    
    // Event listener
    toggleBtn.addEventListener('click', () => {
        const overlay = document.getElementById('illustratorOverlay');
        if (overlay) {
            overlay.classList.toggle('visible');
            toggleBtn.innerHTML = overlay.classList.contains('visible') 
                ? '<i class="fas fa-eye-slash"></i> Masquer'
                : '<i class="fas fa-image"></i> Superposer';
        }
    });
}

// Fonction pour charger une image Illustrator
window.loadIllustratorImage = function(imagePath) {
    const overlay = document.getElementById('illustratorOverlay');
    if (overlay) {
        overlay.src = imagePath;
    }
};

// ===== 6. AMÉLIORATION DES ANIMATIONS AU SURVOL =====
function enhanceHoverAnimations() {
    // Animation des cards de metrics
    const metricCards = document.querySelectorAll('.metric-card');
    metricCards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transition = 'all 0.4s cubic-bezier(0.4, 0, 0.2, 1)';
        });
    });
    
    // Animation des légendes
    const legendItems = document.querySelectorAll('.legend-item');
    legendItems.forEach(item => {
        item.addEventListener('mouseenter', function() {
            this.style.transform = 'scale(1.1)';
            this.style.fontWeight = '700';
        });
        
        item.addEventListener('mouseleave', function() {
            this.style.transform = 'scale(1)';
            this.style.fontWeight = '';
        });
    });
    
    // Animation des indicateurs mathématiques
    const mathIndicators = document.querySelectorAll('.math-indicator');
    mathIndicators.forEach(indicator => {
        indicator.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-3px) scale(1.05)';
        });
        
        indicator.addEventListener('mouseleave', function() {
            this.style.transform = '';
        });
    });
}

// ===== 7. MISE À JOUR DYNAMIQUE DES STATS MATHÉMATIQUES =====
function updateStatsDisplay(year) {
    const yearsData = window.CSV_DATA?.years;
    if (!yearsData) return;
    
    const tvData = yearsData.tv?.[year];
    const radioData = yearsData.radio?.[year];
    
    if (!tvData && !radioData) return;
    
    // Collecter les valeurs
    const allValues = [];
    const tvValues = [];
    const radioValues = [];
    
    if (tvData) {
        Object.values(tvData).forEach(value => {
            if (typeof value === 'number') {
                allValues.push(value);
                tvValues.push(value);
            }
        });
    }
    
    if (radioData) {
        Object.values(radioData).forEach(value => {
            if (typeof value === 'number') {
                allValues.push(value);
                radioValues.push(value);
            }
        });
    }
    
    if (allValues.length > 0) {
        // Calculer les statistiques
        const mean = allValues.reduce((sum, val) => sum + val, 0) / allValues.length;
        const variance = allValues.reduce((sum, val) => sum + Math.pow(val - mean, 2), 0) / allValues.length;
        const stdDev = Math.sqrt(variance);
        
        const sorted = [...allValues].sort((a, b) => a - b);
        const median = sorted.length % 2 === 0
            ? (sorted[sorted.length / 2 - 1] + sorted[sorted.length / 2]) / 2
            : sorted[Math.floor(sorted.length / 2)];
        
        const parityGap = Math.abs(50 - mean);
        
        // Calculer la corrélation TV/Radio
        let correlation = 0;
        if (tvValues.length > 0 && radioValues.length > 0) {
            const minLength = Math.min(tvValues.length, radioValues.length);
            const tvSlice = tvValues.slice(0, minLength);
            const radioSlice = radioValues.slice(0, minLength);
            
            const meanTV = tvSlice.reduce((sum, val) => sum + val, 0) / minLength;
            const meanRadio = radioSlice.reduce((sum, val) => sum + val, 0) / minLength;
            
            let numerator = 0;
            let denomTV = 0;
            let denomRadio = 0;
            
            for (let i = 0; i < minLength; i++) {
                const diffTV = tvSlice[i] - meanTV;
                const diffRadio = radioSlice[i] - meanRadio;
                numerator += diffTV * diffRadio;
                denomTV += diffTV * diffTV;
                denomRadio += diffRadio * diffRadio;
            }
            
            correlation = numerator / Math.sqrt(denomTV * denomRadio);
        }
        
        // Mettre à jour l'affichage avec animation
        updateMetricValue('variance', variance.toFixed(2));
        updateMetricValue('stdDev', stdDev.toFixed(2));
        updateMetricValue('median', median.toFixed(1) + '%');
        updateMetricValue('parityGap', parityGap.toFixed(1) + '%');
        updateMetricValue('correlation', correlation.toFixed(3));
    }
}

function updateMetricValue(id, value) {
    const element = document.getElementById(id);
    if (element) {
        element.classList.add('updating');
        setTimeout(() => {
            element.textContent = value;
            element.classList.remove('updating');
        }, 300);
    }
}

// ===== 8. GESTION DES ERREURS =====
function initErrorHandling() {
    // Errors caught by global handler
    console.log('Gestion des erreurs initialisée');
}

// ===== INITIALISATION AU CHARGEMENT =====
document.addEventListener('DOMContentLoaded', function() {
    console.log('Initialisation des fonctionnalités finales...');
    
    // Initialiser avec un léger délai pour s'assurer que tout est chargé
    setTimeout(() => {
        initYearSelect();
        initBackButton();
        addGlitchTransition();
        createMediaFilter();
        enhanceHoverAnimations();
        initErrorHandling();
        
        // Initialiser les stats
        const yearFilter = document.getElementById('yearFilter');
        if (yearFilter) {
            updateStatsDisplay(yearFilter.value);
        }
        
        // Ajouter l'overlay Illustrator dans le mode artistique
        setTimeout(() => {
            addIllustratorOverlay();
        }, 100);
        
        console.log('Fonctionnalités finales initialisées');
    }, 100);
});

// Export des fonctions
window.updateStatsDisplay = updateStatsDisplay;
window.createMediaFilter = createMediaFilter;
window.enhanceHoverAnimations = enhanceHoverAnimations;

